from flask import Flask, render_template, request
import os
from scripts.tarExtract import allowed_file, extract_tar, print_directory_tree

app = Flask(__name__)

# Configuration
UPLOAD_FOLDER = 'uploads'  # Directory to store uploaded TAR files
ALLOWED_EXTENSIONS = {'tar'}  # Allowed file extensions

app.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER

os.makedirs(UPLOAD_FOLDER, exist_ok=True)

@app.route('/', methods=['GET', 'POST'])
def upload_file():
    """Handle file upload and display the directory tree."""
    if request.method == 'POST':
        if 'file' not in request.files:
            return "No file uploaded", 400
        
        file = request.files['file']
        if file.filename == '':
            return "No file selected", 400
        
        if not allowed_file(file.filename, ALLOWED_EXTENSIONS):
            return "Invalid file type. Only .tar files are allowed.", 400
        
        tar_path = os.path.join(app.config['UPLOAD_FOLDER'], file.filename)
        file.save(tar_path)
        
        extract_dir = './extracted/' + os.path.splitext(file.filename)[0]
        os.makedirs(extract_dir, exist_ok=True)
        extract_tar(tar_path, extract_dir)
        
        tree = print_directory_tree(extract_dir)
        return render_template('result.html', tree=tree)
    
    return render_template('upload.html')

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5000,debug=True)