import os
import tarfile

def allowed_file(filename, allowed_extensions):
    """Check if the uploaded file has an allowed extension."""
    return '.' in filename and filename.rsplit('.', 1)[1].lower() in allowed_extensions

def extract_tar(tar_path, extract_dir):
    try:
        with tarfile.open(tar_path, 'r:*') as tar:
            print(f"Extracting '{tar_path}' to '{extract_dir}'...")
            tar.extractall(path=extract_dir, filter='fully_trusted')
            print("Extraction completed successfully.")
    except tarfile.TarError as e:
        print(f"Error: Failed to extract the TAR file. {e}")

def print_directory_tree(directory, prefix=""):
    tree = []
    contents = os.listdir(directory)
    for i, item in enumerate(contents):
        item_path = os.path.join(directory, item)
        if os.path.isdir(item_path):
            tree.append(f"{prefix}├── {item}/")
            new_prefix = prefix + "│   " if i < len(contents) - 1 else prefix + "    "
            tree.extend(print_directory_tree(item_path, new_prefix))
        else:
            tree.append(f"{prefix}└── {item}")
    return tree