const express = require("express");
const cookieSession = require("cookie-session");
require("dotenv").config();
const app  = express();

app.use(cookieSession({
    name: "session",
    keys: [process.env.KEY1, process.env.KEY2]
}));

app.all("/cors", (req, res) => {
    for (const [key, value] of Object.entries(req.query)) {
        if (key.includes("X-")) delete req.query[key]
    }

    res.set(req.query);
    if (req.session.user === "internal" && !req.query.filename?.includes("/")) {
        res.sendfile(req.query.filename || "app.js");
    } else {
        res.send("Hello World!");
    }
});

app.use(express.static("public"));
app.listen(process.env.PORT, () => {
    console.log(`CORS Playground running on port ${process.env.PORT}`);
});
