function addHeaderRow() {
    const headerSection = document.getElementById("headers-section");
    const headerRow = document.createElement("div");
    headerRow.className = "flex flex-wrap items-center mb-2";

    headerRow.innerHTML = `
        <input type="text" class="header-key border p-2 mr-2 mb-2 flex-grow" placeholder="Header-Name" style="flex-basis: calc(40% - 1rem);">
        <input type="text" class="header-value border p-2 mr-2 mb-2 flex-grow" placeholder="Value" style="flex-basis: calc(40% - 1rem);">
        <button class="removeHeader ml-auto bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded mb-2">Remove</button>
    `;

    headerSection.appendChild(headerRow);
    headerRow.querySelector(".removeHeader").addEventListener("click", function() {
        headerRow.remove();
    });
}


function getRequestHeaders() {
    const headerSection = document.getElementById("headers-section");
    const headerRows = headerSection.querySelectorAll("div");
    const headers = {};

    headerRows.forEach(row => {
        const key = row.querySelector(".header-key").value.trim();
        const value = row.querySelector(".header-value").value.trim();
        if (key && value) {
            headers[key] = value;
        }
    });

    return headers;
}


function getCORSHeaders() {
    const allowOrigin = document.getElementById("allowOrigin").value.trim();
    const allowMethods = document.getElementById("allowMethods").value.trim();
    const allowHeaders = document.getElementById("allowHeaders").value.trim();
    const exposeHeaders = document.getElementById("exposeHeaders").value.trim();
    var corsHeaders = "?";

    if (allowOrigin) {
        corsHeaders += `Access-Control-Allow-Origin=${allowOrigin}&`;
    }
    if (allowMethods) {
        corsHeaders += `Access-Control-Allow-Methods=${allowMethods}&`;
    }
    if (allowHeaders) {
        corsHeaders += `Access-Control-Allow-Headers=${allowHeaders}&`;
    }
    if (exposeHeaders) {
        corsHeaders += `Access-Control-Expose-Headers=${exposeHeaders}`;
    }

    return corsHeaders;
}


function sendRequest() {
    var output = document.getElementById("responseData");
    var res = { headers: {}, body: "" };

    fetch(`${location.protocol}//${location.hostname}.:${location.port}/cors${getCORSHeaders()}`, {
        method: document.getElementById("method").value,
        headers: getRequestHeaders()
    })
    .then((r) => {
        r.headers.forEach((value, key) => {
            res["headers"][key] = value;
        });
        return r.text();
    })
    .then((d) => {
        res["body"] = d;
        output.innerText = JSON.stringify(res, null, 2);
    })
    .catch((e) => {
        output.innerText = `Error: ${e.message}`;
    })
}


window.onload = () => {
    document.getElementById("addHeader").addEventListener("click", addHeaderRow);
    document.getElementById("sendRequest").addEventListener("click", sendRequest);
}
